/* lecture du fichier des distances
 * dans une matrice carree de taille
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>


// remplissage de la matrice Distances
// de taille (TOWNS+1) * (TOWNS+1)
// pour numerotation à partir de 1
#define TOWNS 24
#define THRESH  250
#define INFTY  INT_MAX

int Distances[TOWNS+1][TOWNS+1];
void readDistances (char *filename)
{
	int i, j, k;
	int distance;
	FILE *fp = fopen(filename, "r");

	if (!fp) exit(-1);

	for (j=1; j<=TOWNS; j++) {
		Distances[j][j] = 0;
		for (i=1; i<j; i++) {
			fscanf(fp, "%d", &(Distances[i][j]));
			if (Distances[i][j] < THRESH)
				Distances[j][i] = Distances[i][j];
			else
				Distances[i][j] = Distances[j][i] = INFTY;
		}
	}
	fclose(fp);
}


int cheminDijkstra(int dep, int arr, int C[TOWNS+1])
{
	int i, j;
	int D[TOWNS+1];
	int E[TOWNS+1];

	// init
	for(i=1; i<=TOWNS; i++) {
		D[i] = INFTY;
		C[i] = dep;
		E[i] = 0;
	}
	D[dep] = 0;
	
	while (1) {
		// calc min
		int imin = -1, vmin = INFTY;
		for(i=1; i<=TOWNS; i++) 
			if (D[i]<vmin && E[i]==0) {
				vmin = D[i];
				imin = i;
			}
		if (imin == -1) break
		E[imin] = 1;

		// maj succs
		for(i=1; i<=TOWNS; i++) 
			if (E[i]!=1 && Distances[imin][i]!=INFTY) {
				int v = D[imin] + Distances[imin][i];
				if (v < D[i]) {
					D[i] = v;
					C[i] = imin;
				}
			}
	}

	return D[arr];
}

struct { char nom[128]; double lon, lat; } infoTowns[TOWNS+1];

void readTowns(char *fname)
{
	FILE *fp = fopen(fname, "r");
	int i = 1;
	while (fscanf(fp, "%s%lf%lf", infoTowns[i].nom, &(infoTowns[i].lon), &(infoTowns[i].lat)) == 3) i++;
	fclose(fp);
}

void printPath(char *fname, int dep, int arr, int C[])
{
	FILE *fp = fopen(fname, "w");
	int i = arr;
	while (1) {
		fprintf(fp, "%s %lf %lf\n", infoTowns[i].nom, infoTowns[i].lon, infoTowns[i].lat);
		if (i == dep) break;
		i = C[i];
	}
	fclose(fp);
}

// exemple d'utilisation

main() {
        int som, dep = 3 /* Brest */, arr = 17 /* Nice */;
        int dist;
        int C[TOWNS+1];

        readDistances("distances.dat");

        // test de l'algorithme de Dijkstra
        dist = cheminDijkstra(dep, arr, C);
        printf("distance totale : %d\n", dist);

        readTowns("villes.dat");
        printPath("trajet.dat", dep /* Brest */, arr /* Nice */, C);
        system("gnuplot plot.script");

	// generer dans aretes.dat la liste des aretes (2 lignes / arete + 1 ligne blanche)
	// system("gnuplot plotGraph.script");
	// le graphe utilisé sera dans graph.gif

}

